---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：31-ffmpeg Mux

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **C-18 パフォーマンス要件**：具体的なベンチマーク根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `Source/General/Muxer.vb` - ffmpegMuxerクラス定義（1009-1120行目）
- E-02: `Source/General/Muxer.vb` - Mux()メソッド（1057-1093行目）
- E-03: `Source/General/Muxer.vb` - SupportedFormatsプロパティ（1025-1029行目）
- E-04: `Source/General/Muxer.vb` - AVITypesプロパティ（1019-1022行目）
- E-05: `Source/General/Muxer.vb` - Edit()メソッド（1095-1119行目）
- E-06: `Source/General/Muxer.vb` - IsSupported()メソッド（1046-1050行目）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.31の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ffmpeg Muxはffmpegツールを使用して多重化する機能である | E-01, E-02 | ○ |
| C-02 | 対応フォーマットはASF、AVI、FLV、ISMV、IVF、MKV、MOV、MP4、MPG、MXF、NUT、OGG、TS、WEBM、WMV | E-03 | ○ |
| C-03 | AVI出力時はサポート入力タイプが制限される | E-04, E-06 | ○ |
| C-04 | ビデオ入力ファイルはエンコーダ出力またはソースファイル | E-02 (1060-1064行目) | ○ |
| C-05 | オーディオトラックは対応形式チェック後に追加される | E-02 (1069-1079行目) | ○ |
| C-06 | ストリームマッピングで-map 0:vと-map Nを使用 | E-02 (1067, 1073行目) | ○ |
| C-07 | コーデックコピー（-c:v copy -c:a copy）を使用 | E-02 (1081行目) | ○ |
| C-08 | MOV/MP4/ISMVの場合は-movflags +faststartを付与 | E-02 (1082行目) | ○ |
| C-09 | Procクラスを使用してffmpegを実行 | E-02 (1085-1092行目) | ○ |
| C-10 | SimpleSettingsFormで出力フォーマット選択ダイアログを表示 | E-05 (1096-1097行目) | ○ |
| C-11 | OutputFormatプロパティで出力形式を管理 | E-01 (1013行目) | ○ |
| C-12 | 出力拡張子はOutputExtプロパティで小文字変換される | E-01 (1032-1036行目) | ○ |
| C-13 | ffmpegの基本引数は-y -hide_banner -probesize 10M | E-02 (1058行目) | ○ |
| C-14 | Package.ffmpegでffmpegパスを解決 | E-02 (1089行目) | ○ |
| C-15 | エンコード済みビデオファイル存在確認を行う | E-02 (1060行目) | ○ |
| C-16 | AVITypesはavi, mp2, mp3, ac3, mpa, wavを含む | E-04 | ○ |
| C-17 | MuxerはProfileクラスを継承 | E-01 (12-14行目) | ○ |
| C-18 | 処理時間は入力ファイルサイズに比例する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18に関して、パフォーマンス特性の具体的なベンチマークデータが存在しない
  - 候補：実測データの追加 / ffmpegドキュメントの参照 / コード内コメントの確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能説明はすべてコードで確認済み
- 1: 中リスク - パフォーマンス要件の具体的根拠が不足

## 6) レビュアーチェックリスト（最小）
- [ ] SupportedFormatsの一覧が最新のffmpegMuxerコードと一致しているか
- [ ] AVITypesの制限が正しく記載されているか
- [ ] faststart フラグの条件判定が正確か
- [ ] 関連画面の記載が画面機能マッピングと整合しているか
